﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace GUSLogReader
{
    

    public partial class frmLogTypes : Form
    {
        public frmLogTypes(List<String> logtypen)
        {
            InitializeComponent();

            lv.Items.Clear();

            foreach (var item in logtypen)
            {
                lv.Items.Add(item);
            }
        }




        private static DialogResult ShowInputDialog(ref string input)
        {
            System.Drawing.Size size = new System.Drawing.Size(200, 70);
            Form inputBox = new Form();

            inputBox.StartPosition = FormStartPosition.CenterParent;
            inputBox.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            inputBox.ClientSize = size;
            inputBox.Text = "Name";

            System.Windows.Forms.TextBox textBox = new TextBox();
            textBox.Size = new System.Drawing.Size(size.Width - 10, 23);
            textBox.Location = new System.Drawing.Point(5, 5);
            textBox.Text = input;
            inputBox.Controls.Add(textBox);

            Button okButton = new Button();
            okButton.DialogResult = System.Windows.Forms.DialogResult.OK;
            okButton.Name = "okButton";
            okButton.Size = new System.Drawing.Size(75, 23);
            okButton.Text = "&OK";
            okButton.Location = new System.Drawing.Point(size.Width - 80 - 80, 39);
            inputBox.Controls.Add(okButton);

            Button cancelButton = new Button();
            cancelButton.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            cancelButton.Name = "cancelButton";
            cancelButton.Size = new System.Drawing.Size(75, 23);
            cancelButton.Text = "&Cancel";
            cancelButton.Location = new System.Drawing.Point(size.Width - 80, 39);
            inputBox.Controls.Add(cancelButton);

            inputBox.AcceptButton = okButton;
            inputBox.CancelButton = cancelButton;

            DialogResult result = inputBox.ShowDialog();
            input = textBox.Text;
            return result;
        }
        public List<String> getLogTypes()
        {
            var list = new List<String>();

            foreach (var item in lv.Items)
            {
                list.Add(((ListViewItem)item).Text);
            }
            return list;
        }
        private void button2_Click(object sender, EventArgs e)
        {
            string logtyp = "os*.*";
            if (ShowInputDialog(ref logtyp) == DialogResult.OK)
            {
                lv.Items.Add(logtyp);
            }

        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (!(lv.SelectedItems == null))
            {
                lv.Items.Remove(lv.SelectedItems[0]);
            }
        }
    }
}
