﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using System.Reflection;

namespace GUSLogReader
{
    public partial class frmInfo : Form
    {
        public frmInfo(string version)
        {
            InitializeComponent();
            
            //GenerateCompressedInfos(); return;

            string compRTF;
            var assembly = Assembly.GetExecutingAssembly();
            var resourceName = String.Format("GUSLogReader.Resources.About.rtf.zip");

            using (Stream stream = assembly.GetManifestResourceStream(resourceName))
            using (StreamReader reader = new StreamReader(stream))
            {
                compRTF = reader.ReadToEnd();

            }

            string rtf = CompressString.StringCompressor.DecompressString(compRTF);
            this.richTextBox1.Rtf = rtf;

            this.Text = "GUS-Log Reader - Version " + version;
        }

        private static void GenerateCompressedInfos()
        {
            var str = File.ReadAllText(@"D:\VS2017\GUSLogReader\GUSLogReader\About.rtf");
            string comp = CompressString.StringCompressor.CompressString(str);

            File.WriteAllText(@"D:\VS2017\GUSLogReader\GUSLogReader\About.rtf.zip",comp);
            MessageBox.Show("Done.");
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            System.Diagnostics.Process.Start(frmMain.SOURCEURL);
        }
    }
}
