﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;
using System.IO;

namespace GUSLogReader
{
    public class XMLHelper
    {
        public static T DeSerializeAtomic<T>(string serializedString)
        {
            if ((serializedString == null) || (serializedString.Trim().Equals("")))
                throw new FormatException("Der Typ kann nicht Deserialisiert werden!");

            StringBuilder input = new StringBuilder(serializedString);
            var reader = new StringReader(serializedString);

            XmlSerializer serializer = new XmlSerializer(typeof(T));
            var result = (T)serializer.Deserialize(reader);

            return result;
        }
        public static T DeSerialize<T>(string serializedString) where T : new()
        {
            if ((serializedString == null) || (serializedString.Trim().Equals("")))
                return new T();
            
            StringBuilder input = new StringBuilder(serializedString);
            var reader = new StringReader(serializedString);

            XmlSerializer serializer = new XmlSerializer(typeof(T));
            var result = (T)serializer.Deserialize(reader);
     
            return result;
        }
        public static string Serialize<T>(T toSerialize)
        {
            StringBuilder output = new StringBuilder();
            var writer = new StringWriter(output);

            XmlSerializer serializer = new XmlSerializer(typeof(T));
            serializer.Serialize(writer, toSerialize);

            return output.ToString();
        }


    }

}
