﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Collections;
namespace GUSLogReader
{
    [Serializable]
    public class RecentFiles
    {
        public  List<String> FileNames { get; set; }

        public RecentFiles()
        {
            FileNames = new List<string>();  
        }

        public void AddFile(string filename)
        {            
            if (FileNames.Contains(filename))
                FileNames.Remove(filename);

            if (FileNames.Count > 9)
                FileNames.RemoveAt(0);

            FileNames.Add(filename);
        }

        public List<String> GetFiles()
        {
            var temp = new List<String>(FileNames);
            temp.Reverse();
            return temp;
        }
    }

    public class RecentFilesHelper
    {
        public RecentFiles files;

        private string ConfDir { get; set; }
        public RecentFilesHelper(String configDir)
        {
            ConfDir = configDir;
            loadRecentFiles();

        }

        public void loadRecentFiles()
        {
            var path = Path.Combine(ConfDir, "recent.conf");

            if (File.Exists(path))
                files = XMLHelper.DeSerialize<RecentFiles>(File.ReadAllText(path));
            else
            {
                files = new RecentFiles();
                File.WriteAllText(path, XMLHelper.Serialize(files));
            }
        }
        public void saveRecentFiles()
        {
            var path = Path.Combine(ConfDir, "recent.conf");
            File.WriteAllText(path, XMLHelper.Serialize(files));
        }
    }
}
