﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
namespace GUSLogReader
{
    public class MSG
    {
        public String ID { get; set; }
        public DateTime TS { get; set; }
        public String Kat { get; set; }
        public String Thread { get; set; }
        public String Klasse { get; set; }
        public String Msg1stL { get; set; } //1st line of MSG
        public String Message { get; set; }
        public String Source { get; set; }
        public int MarkerID { get; set; }

        public MSG()
        {
            MarkerID = 0;
            this.ID = Guid.NewGuid().ToString();
        }
        public MSG(String messageSource)
        {
            MarkerID = 0;
            this.Source = messageSource;
            this.ID = Guid.NewGuid().ToString();
        }
        public MSG(bool generateID)
        {
            MarkerID = 0;
            if (generateID)
                this.ID = Guid.NewGuid().ToString();
        }
    }

    public class MsgReader
    {

        public static List<MSG> processFile(String fileName, int sameTimeValue)
        {
            var lines = new List<String>();
            var list = new List<MSG>();
            MSG lastmsg = null;
            var ms = new MemoryStream();
            int counter = 0;

            using (var fs = new FileStream(fileName, FileMode.Open, FileAccess.Read, FileShare.ReadWrite))     
                fs.CopyTo(ms);

            ms.Position = 0;            

            using (var sr = new StreamReader(ms, Encoding.Default))
            {
                while (!sr.EndOfStream)
                    lines.Add(sr.ReadLine());
            }


            foreach (var line in lines)
            {
                bool canParse = false;
                bool sameTime = false;
                var ts = new DateTime();
                counter++;

                if (line.Length > 25)
                {
                    var beg = line.Substring(0, 23);
                    
                    canParse = (DateTime.TryParseExact(beg, "yyyy-MM-dd HH:mm:ss,fff", new System.Globalization.CultureInfo("de-DE"), System.Globalization.DateTimeStyles.None, out ts));

                    if (lastmsg != null)
                    {
                        var diff = ts - lastmsg.TS;
                        if (diff.TotalMilliseconds < sameTimeValue)
                            sameTime = true;
                    }
                }
                
                if (canParse)
                {
                    string uniqe = Path.GetFileName(fileName) + counter.ToString();
                    

                    if (!sameTime)
                    {
                        lastmsg = parseFirstLine(line, fileName, ts, uniqe);
                        list.Add(lastmsg);
                    }
                    else
                    {
                        var temp = parseFirstLine(line, fileName, ts, uniqe);
                        if (!(lastmsg == null))
                        {
                            if (list.Last().ID == lastmsg.ID)
                            {
                                list.Last().Message += Environment.NewLine + temp.Msg1stL;
                            }
                            else
                            {
                                list.Find(x => x.ID == lastmsg.ID).Message += Environment.NewLine + line;
                            }
                        }
                    }
                }
                else
                {
                    if (!(lastmsg == null))
                    {
                        if (list.Last().ID == lastmsg.ID)
                        {
                            list.Last().Message += Environment.NewLine + line;
                        }
                        else
                        {
                            list.Find(x => x.ID == lastmsg.ID).Message += Environment.NewLine + line;
                        }
                    }
                }
                


            }


            return list;
        }

        private static MSG parseFirstLine(string line, string MessageSource, DateTime parsedDate, string unique)
        {
            var obj = new MSG(false);

            var beg = line.Substring(0, 23);
            String Kat = "";
            String Thread = "";
            String Klasse = "";
            String Message = "";
            int lastPos = 27;
            int nextPos = 24;


            //Kategorie

            lastPos = line.IndexOf(" ", nextPos);
            Kat = line.Substring(nextPos, lastPos - nextPos);

            //Thread
            nextPos = line.IndexOf("[");
            lastPos = line.IndexOf("]", nextPos);
            Thread = line.Substring(nextPos, lastPos - nextPos+1);
            nextPos = lastPos+1;

            
            while (line.Substring(nextPos, 1) == " ")
            {
                nextPos++;
            }

            lastPos = line.IndexOf(" ", nextPos);
            Klasse = line.Substring(nextPos, lastPos - nextPos);

            nextPos = lastPos;


            while (line.Substring(nextPos, 1) == " ")
            {
                nextPos++;
            }

            Message = line.Substring(nextPos-1, line.Length - nextPos+1);
            Message = Message.Trim().TrimStart('-').TrimStart();

            obj.ID = unique;
            obj.TS = parsedDate;
            obj.Kat = Kat;
            obj.Thread = Thread;
            obj.Klasse = Klasse;
            obj.Message = Message;
            obj.Msg1stL = Message;
            obj.Source = MessageSource;

            return obj;

        }
    }
}
