﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
namespace GUSLogReader
{


    [Serializable]
    public class Logfiles
    {
        public List<String> Path { get; set; }
        public List<String> Prefixes { get; set; }
        public String ListViewConfig { get; set; }
        public int FileMaxAge { get; set; }
        public bool CheckFileMaxAge { get; set; }

        public int SameTimeValue { get; set; }

        public String TextFormatLine { get; set; }
        public SourceFilter filters { get; set; }

        public System.Windows.Forms.FormWindowState LastWindowState { get; set; }
        public Logfiles()
        {
            Prefixes = new List<string>();
            Path = new List<string>();
            ListViewConfig = "";
            FileMaxAge = 14;
            CheckFileMaxAge = true;
            SameTimeValue = 2;
            LastWindowState = System.Windows.Forms.FormWindowState.Normal;
            TextFormatLine = "{0:yyyy-MM-dd HH:mm:ss,fff} {1} {2} {3} {4}";
            this.filters = new SourceFilter();
        }

        public static List<string> RecursiveDirSearch(string sDir, string pattern)
        {
            var lst = new List<String>();
            try
            {
                foreach (string f in Directory.GetFiles(sDir, pattern))
                {
                    lst.Add(f);
                }
                foreach (string d in Directory.GetDirectories(sDir))
                {
                    foreach (string f in Directory.GetFiles(d, pattern))
                    {
                        lst.Add(f);
                    }
                    lst.AddRange(RecursiveDirSearch(d,pattern));
                }
            }
            catch (System.Exception excpt)
            {
                return new List<String>();
            }
            return lst;
        }
    }
}
